/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.widgets;

import com.biglybt.core.category.Category;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.ui.swt.widgets.TagPainter;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TagCanvas
extends Canvas
implements PaintListener,
Listener,
DropTargetListener,
DragSourceListener {
    private boolean initialised;
    private final DropTarget dropTarget;
    private final DragSource dragSource;
    private final TagPainter painter;
    private boolean mouseDown = false;
    private boolean dndListenersAdded;
    private TimerEvent timerEvent;

    public TagCanvas(Composite parent, Tag tag) {
        this(parent, tag, true, false);
    }

    public TagCanvas(Composite parent, Tag tag, boolean disableAuto, boolean enableWhenNoTaggables) {
        super(parent, 0x20000000);
        try {
            this.painter = new TagPainter(tag, this);
            this.painter.enableWhenNoTaggables = enableWhenNoTaggables;
            boolean[] auto = tag.isTagAuto();
            if (auto.length >= 2 && auto[0] && auto[1]) {
                this.painter.font = FontUtils.getFontWithStyle(this.getFont(), 2, 1.0f);
                this.setFont(this.painter.font);
            }
            this.painter.updateColors((Device)this.getDisplay(), this.getForeground(), this.getBackground());
            this.painter.setDisableAuto(disableAuto);
            this.addListener(3, this);
            this.addListener(4, this);
            this.addListener(1, this);
            this.addListener(16, this);
            this.addListener(15, this);
            this.addListener(31, this);
            this.addListener(32, this);
            this.addListener(7, this);
            this.dropTarget = new DropTarget((Control)this, 23);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            this.dropTarget.setTransfer(types);
            this.dropTarget.addDropListener((DropTargetListener)this);
            this.dragSource = DragDropUtils.createDragSource((Control)this, 3);
            this.dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.dragSource.addDragListener((DragSourceListener)this);
            this.dndListenersAdded = true;
            this.painter.updateImage();
            this.addPaintListener(this);
        }
        finally {
            this.initialised = true;
        }
    }

    protected boolean isInitialised() {
        return this.initialised;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point point = this.painter.computeSize((Device)this.getDisplay(), this.getFont());
        if (point == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        return point;
    }

    public void handleEvent(Event e) {
        switch (e.type) {
            case 3: {
                if (!this.isEnabled() || e.button != 1 && e.button != 2) {
                    return;
                }
                this.dropTarget.removeDropListener((DropTargetListener)this);
                this.dndListenersAdded = false;
                if (this.timerEvent == null) {
                    this.timerEvent = SimpleTimer.addEvent("MouseHold", SystemTime.getOffsetTime(500L), te -> {
                        this.timerEvent = null;
                        if (!this.mouseDown) {
                            return;
                        }
                        if (this.painter.trigger == null) {
                            this.mouseDown = false;
                            return;
                        }
                        Utils.execSWTThread(() -> {
                            if (!this.mouseDown) {
                                return;
                            }
                            if (event2.display.getCursorControl() != this) {
                                return;
                            }
                            this.mouseDown = false;
                            this.painter.trigger.tagButtonTriggered(this.painter, event2.stateMask, true);
                        });
                    });
                }
                this.mouseDown = true;
                break;
            }
            case 4: {
                if (!this.isEnabled() || e.button != 1 && e.button != 2 || !this.mouseDown) {
                    return;
                }
                this.mouseDown = false;
                if (this.timerEvent != null) {
                    this.timerEvent.cancel();
                    this.timerEvent = null;
                }
                if (!this.getClientArea().contains(e.x, e.y)) {
                    return;
                }
                if (this.painter.trigger == null) break;
                this.painter.trigger.tagButtonTriggered(this.painter, e.stateMask, e.button == 2);
                break;
            }
            case 32: {
                Utils.setTT((Control)this, TagUtils.getTagTooltip(this.painter.tag));
                break;
            }
            case 7: {
                this.setToolTipText(null);
                if (!this.dndListenersAdded) {
                    this.dropTarget.addDropListener((DropTargetListener)this);
                    this.dndListenersAdded = true;
                }
            }
            case 15: 
            case 16: {
                this.redraw();
                break;
            }
            case 31: {
                if (!this.isEnabled()) {
                    return;
                }
                switch (e.detail) {
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                    case 4: {
                        if (this.painter.trigger == null) break;
                        this.painter.trigger.tagButtonTriggered(this.painter, e.stateMask, false);
                    }
                }
                e.doit = true;
            }
            case 1: {
                if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    if (this.painter.tag.getTagType().isTagTypeAuto()) break;
                    TagUIUtils.openRenameTagDialog(this.painter.tag);
                    e.doit = false;
                    break;
                }
                if (e.keyCode != 32 || this.painter.trigger == null) break;
                this.painter.trigger.tagButtonTriggered(this.painter, e.stateMask, false);
            }
        }
    }

    public void paintControl(PaintEvent e) {
        this.painter.paintControl(e.gc, 0, 0, this.getClientArea(), this.getSize(), this.isFocusControl());
    }

    public void dispose() {
        super.dispose();
        this.painter.dispose();
        this.dropTarget.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.painter.setEnabled(enabled);
    }

    public boolean getEnabled() {
        return this.painter.isEnabled;
    }

    public boolean isEnabled() {
        return this.painter.isEnabled && super.isEnabled();
    }

    public void setTrigger(TagButtonTrigger trigger) {
        this.painter.trigger = trigger;
    }

    private static List<DownloadManager> handleDropTargetEvent(DropTargetEvent e) {
        Object data = e.data == null ? DragDropUtils.getLastDraggedObject() : e.data;
        List<DownloadManager> dms = DragDropUtils.getDownloadsFromDropData(data, false);
        if (dms.isEmpty()) {
            e.detail = 0;
            return dms;
        }
        boolean doAdd = false;
        Control dropControl = ((DropTarget)e.widget).getControl();
        if (!(dropControl instanceof TagCanvas)) {
            e.detail = 0;
            return dms;
        }
        Tag tag = ((TagCanvas)dropControl).getTagPainter().getTag();
        for (DownloadManager dm : dms) {
            if (tag.hasTaggable(dm)) continue;
            doAdd = true;
            break;
        }
        boolean[] auto = tag.isTagAuto();
        if (auto.length < 2 || doAdd && auto[0] || !doAdd && auto[0] && auto[1]) {
            e.detail = 0;
            return dms;
        }
        e.detail = doAdd ? 1 : 2;
        return dms;
    }

    public void dragEnter(DropTargetEvent event2) {
        TagCanvas.handleDropTargetEvent(event2);
    }

    public void dragLeave(DropTargetEvent event2) {
    }

    public void dragOperationChanged(DropTargetEvent event2) {
    }

    public void dropAccept(DropTargetEvent event2) {
        TagCanvas.handleDropTargetEvent(event2);
    }

    public void dragOver(DropTargetEvent e) {
        TagCanvas.handleDropTargetEvent(e);
    }

    public void drop(DropTargetEvent e) {
        List<DownloadManager> dms = TagCanvas.handleDropTargetEvent(e);
        if (dms.isEmpty()) {
            return;
        }
        Control dropControl = ((DropTarget)e.widget).getControl();
        if (!(dropControl instanceof TagCanvas)) {
            return;
        }
        Tag tag = ((TagCanvas)dropControl).getTagPainter().getTag();
        if (tag instanceof Category) {
            TorrentUtil.assignToCategory(dms.toArray(), (Category)tag);
            return;
        }
        boolean doAdd = e.detail == 1;
        Utils.getOffOfSWTThread(() -> {
            for (DownloadManager dm : dms) {
                if (doAdd) {
                    tag.addTaggable(dm);
                    continue;
                }
                tag.removeTaggable(dm);
            }
        });
    }

    public void dragStart(DragSourceEvent event2) {
    }

    public void dragSetData(DragSourceEvent event2) {
        event2.data = "TagUID\n" + this.painter.tag.getTagUID();
    }

    public void dragFinished(DragSourceEvent event2) {
    }

    public TagPainter getTagPainter() {
        return this.painter;
    }

    public static interface TagButtonTrigger {
        public void tagButtonTriggered(TagPainter var1, int var2, boolean var3);

        public Boolean tagSelectedOverride(Tag var1);
    }
}

