/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.win32;

import com.biglybt.core.drivedetector.DriveDetectedInfo;
import com.biglybt.core.drivedetector.DriveDetector;
import com.biglybt.core.drivedetector.DriveDetectorFactory;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.platform.win32.access.AEWin32Manager;
import com.biglybt.platform.win32.access.impl.AEWin32AccessInterface;
import com.biglybt.ui.swt.Utils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class Win32UIEnhancer {
    public static final boolean DEBUG = false;
    public static final int SHGFI_ICON = 256;
    public static final int SHGFI_SMALLICON = 1;
    public static final int SHGFI_USEFILEATTRIBUTES = 16;
    public static final int SHGFI_LARGEICON = 2;
    public static final int WM_DEVICECHANGE = 537;
    public static final int DBT_DEVICEARRIVAL = 32768;
    public static final int DBT_DEVICEREMOVECOMPLETE = 32772;
    public static final int DBT_DEVTYP_VOLUME = 2;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    private static int messageProcInt;
    private static long messageProcLong;
    private static Object messageCallback;
    private static DriveDetectedInfo loc;
    private static Class<?> claOS;
    private static boolean useLong;
    private static Class<?> claCallback;
    private static Constructor<?> constCallBack;
    private static Method mCallback_getAddress;
    private static Method mSetWindowLongPtr;
    private static int OS_GWLP_WNDPROC;
    private static Method mOS_memmove_byte;
    private static Method mOS_memmove_int;
    private static Class<?> claSHFILEINFO;
    private static Class<?> claSHFILEINFO_Target;
    private static Method mSHGetFileInfo;
    private static Method mImage_win32_new;
    private static boolean mImage_win32_new_hasNativeZoom;
    private static Constructor<?> constTCHAR3;
    private static int SHFILEINFO_sizeof;
    private static long oldProc;
    private static Method mGetWindowLongPtr;
    private static Method mCallWindowProc;

    static {
        try {
            claOS = Class.forName("org.eclipse.swt.internal.win32.OS");
            boolean alwaysUnicode = SWT.getVersion() >= 4924;
            boolean isUnicode = alwaysUnicode ? true : claOS.getDeclaredField("IsUnicode").getBoolean(null);
            claSHFILEINFO = Class.forName("org.eclipse.swt.internal.win32.SHFILEINFO");
            SHFILEINFO_sizeof = claSHFILEINFO.getField("sizeof").getInt(null);
            claSHFILEINFO_Target = isUnicode ? (alwaysUnicode ? claSHFILEINFO : Class.forName("org.eclipse.swt.internal.win32.SHFILEINFOW")) : Class.forName("org.eclipse.swt.internal.win32.SHFILEINFOA");
            if (alwaysUnicode) {
                mSHGetFileInfo = claOS.getMethod("SHGetFileInfo", char[].class, Integer.TYPE, claSHFILEINFO, Integer.TYPE, Integer.TYPE);
            } else {
                Class<?> claTCHAR = Class.forName("org.eclipse.swt.internal.win32.TCHAR");
                constTCHAR3 = claTCHAR.getConstructor(Integer.TYPE, String.class, Boolean.TYPE);
                mSHGetFileInfo = claOS.getMethod("SHGetFileInfo", claTCHAR, Integer.TYPE, claSHFILEINFO, Integer.TYPE, Integer.TYPE);
            }
            claCallback = Class.forName("org.eclipse.swt.internal.Callback");
            constCallBack = claCallback.getDeclaredConstructor(Object.class, String.class, Integer.TYPE);
            mCallback_getAddress = claCallback.getDeclaredMethod("getAddress", new Class[0]);
            try {
                mSetWindowLongPtr = claOS.getMethod("SetWindowLongPtr", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                mGetWindowLongPtr = claOS.getMethod("GetWindowLongPtr", Integer.TYPE, Integer.TYPE);
                mCallWindowProc = claOS.getMethod("CallWindowProc", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                useLong = false;
                mOS_memmove_byte = claOS.getMethod("memmove", byte[].class, Integer.TYPE, Integer.TYPE);
                mOS_memmove_int = claOS.getMethod("memmove", int[].class, Integer.TYPE, Integer.TYPE);
                mImage_win32_new = Image.class.getMethod("win32_new", Device.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                mSetWindowLongPtr = claOS.getMethod("SetWindowLongPtr", Long.TYPE, Integer.TYPE, Long.TYPE);
                mGetWindowLongPtr = claOS.getMethod("GetWindowLongPtr", Long.TYPE, Integer.TYPE);
                mCallWindowProc = claOS.getMethod("CallWindowProc", Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE);
                useLong = true;
                mOS_memmove_byte = claOS.getMethod("memmove", byte[].class, Long.TYPE, Long.TYPE);
                mOS_memmove_int = claOS.getMethod("memmove", int[].class, Long.TYPE, Long.TYPE);
                try {
                    mImage_win32_new = Image.class.getMethod("win32_new", Device.class, Integer.TYPE, Long.TYPE);
                }
                catch (Throwable f) {
                    mImage_win32_new = Image.class.getMethod("win32_new", Device.class, Integer.TYPE, Long.TYPE, Integer.TYPE);
                    mImage_win32_new_hasNativeZoom = true;
                }
            }
            OS_GWLP_WNDPROC = (Integer)claOS.getField("GWLP_WNDPROC").get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Image getFileIcon(File file, boolean big) {
        Field fldHIcon;
        Object shfi;
        block10: {
            try {
                Object pszPath;
                int flags = 256;
                flags |= big ? 2 : 1;
                if (!file.exists()) {
                    flags |= 0x10;
                }
                shfi = claSHFILEINFO_Target.newInstance();
                String path = file.getAbsolutePath();
                if (constTCHAR3 == null) {
                    char[] temp = path.toCharArray();
                    char[] chars = new char[temp.length + 1];
                    System.arraycopy(temp, 0, chars, 0, temp.length);
                    chars[chars.length - 1] = '\u0000';
                    pszPath = chars;
                } else {
                    pszPath = constTCHAR3.newInstance(0, path, true);
                }
                mSHGetFileInfo.invoke(null, pszPath, file.isDirectory() ? 16 : 128, shfi, SHFILEINFO_sizeof, flags);
                fldHIcon = claSHFILEINFO.getField("hIcon");
                if (fldHIcon.getLong(shfi) != 0L) break block10;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        Image image = null;
        if (useLong) {
            if (mImage_win32_new_hasNativeZoom) {
                Object[] objectArray = new Object[4];
                objectArray[1] = 1;
                objectArray[2] = fldHIcon.getLong(shfi);
                objectArray[3] = Utils.getNativeDeviceZoom();
                image = (Image)mImage_win32_new.invoke(null, objectArray);
            } else {
                Object[] objectArray = new Object[3];
                objectArray[1] = 1;
                objectArray[2] = fldHIcon.getLong(shfi);
                image = (Image)mImage_win32_new.invoke(null, objectArray);
            }
        } else {
            Object[] objectArray = new Object[3];
            objectArray[1] = 1;
            objectArray[2] = fldHIcon.getInt(shfi);
            image = (Image)mImage_win32_new.invoke(null, objectArray);
        }
        return image;
    }

    public static void initMainShell(Shell shell) {
        Shell subshell = new Shell(shell);
        try {
            messageCallback = constCallBack.newInstance(Win32UIEnhancer.class, "messageProc2", 4);
            Object oHandle = subshell.getClass().getField("handle").get(subshell);
            oldProc = ((Number)mGetWindowLongPtr.invoke(null, oHandle, OS_GWLP_WNDPROC)).longValue();
            if (useLong) {
                Number n = (Number)mCallback_getAddress.invoke(messageCallback, new Object[0]);
                messageProcLong = n.longValue();
                if (messageProcLong != 0L) {
                    mSetWindowLongPtr.invoke(null, oHandle, OS_GWLP_WNDPROC, messageProcLong);
                }
            } else {
                Number n = (Number)mCallback_getAddress.invoke(messageCallback, new Object[0]);
                messageProcInt = n.intValue();
                if (messageProcInt != 0) {
                    mSetWindowLongPtr.invoke(null, oHandle, OS_GWLP_WNDPROC, messageProcInt);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        new AEThread2("Async:USB"){

            @Override
            public void run() {
                String version;
                if (Constants.isWindows7OrHigher && Constants.compareVersions("1.21", version = AEWin32Manager.getAccessor(false).getVersion()) > 0) {
                    return;
                }
                Map<File, Map> drives = AEWin32Manager.getAccessor(false).getAllDrives();
                if (drives != null) {
                    for (File file : drives.keySet()) {
                        Map driveInfo = drives.get(file);
                        boolean isWritableUSB = AEWin32Manager.getAccessor(false).isUSBDrive(driveInfo);
                        driveInfo.put("isWritableUSB", isWritableUSB);
                        DriveDetectorFactory.getDeviceDetector().driveDetected(file, driveInfo);
                    }
                }
            }
        }.start();
    }

    static int messageProc2(int hwnd, int msg, int wParam, int lParam) {
        return (int)Win32UIEnhancer.messageProc2((long)hwnd, (long)msg, (long)wParam, (long)lParam);
    }

    static long messageProc2(long hwnd, long msg, long wParam, long lParam) {
        try {
            switch ((int)msg) {
                case 537: {
                    if (wParam == 32768L) {
                        int[] st = new int[3];
                        if (useLong) {
                            mOS_memmove_int.invoke(null, st, lParam, 12L);
                        } else {
                            mOS_memmove_int.invoke(null, st, (int)lParam, 12);
                        }
                        if (st[1] != 2) break;
                        byte[] b = new byte[st[0]];
                        if (useLong) {
                            mOS_memmove_byte.invoke(null, b, lParam, st[0]);
                        } else {
                            mOS_memmove_byte.invoke(null, b, (int)lParam, st[0]);
                        }
                        long unitMask = (b[12] & 0xFF) + ((b[13] & 0xFF) << 8) + ((b[14] & 0xFF) << 16) + ((b[15] & 3) << 24);
                        char letter = '?';
                        int i = 0;
                        while (i < 26) {
                            if (((long)(1 << i) & unitMask) > 0L) {
                                letter = (char)(65 + i);
                                Map driveInfo = AEWin32AccessInterface.getDriveInfo(letter);
                                boolean isWritableUSB = AEWin32Manager.getAccessor(false).isUSBDrive(driveInfo);
                                driveInfo.put("isWritableUSB", isWritableUSB);
                                DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                                driveDetector.driveDetected(new File(String.valueOf(letter) + ":\\"), driveInfo);
                            }
                            ++i;
                        }
                    } else {
                        DriveDetectedInfo[] existingDrives;
                        if (wParam != 32772L) break;
                        int[] st = new int[3];
                        if (useLong) {
                            mOS_memmove_int.invoke(null, st, lParam, 12L);
                        } else {
                            mOS_memmove_int.invoke(null, st, (int)lParam, 12);
                        }
                        if (st[1] != 2) break;
                        byte[] b = new byte[st[0]];
                        if (useLong) {
                            mOS_memmove_byte.invoke(null, b, lParam, st[0]);
                        } else {
                            mOS_memmove_byte.invoke(null, b, (int)lParam, st[0]);
                        }
                        long unitMask = (b[12] & 0xFF) + ((b[13] & 0xFF) << 8) + ((b[14] & 0xFF) << 16) + ((b[15] & 3) << 24);
                        char letter = '?';
                        DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                        int i = 0;
                        while (i < 26) {
                            if (((long)(1 << i) & unitMask) > 0L) {
                                letter = (char)(65 + i);
                                driveDetector.driveRemoved(new File(String.valueOf(letter) + ":\\"));
                            }
                            ++i;
                        }
                        Map<File, Map> drives = AEWin32Manager.getAccessor(false).getAllDrives();
                        if (drives == null) break;
                        DriveDetectedInfo[] driveDetectedInfoArray = existingDrives = driveDetector.getDetectedDriveInfo();
                        int n = existingDrives.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DriveDetectedInfo existingDrive = driveDetectedInfoArray[n2];
                            File existingDriveFile = existingDrive.getLocation();
                            boolean found = drives.containsKey(existingDriveFile);
                            if (!found) {
                                driveDetector.driveRemoved(existingDriveFile);
                            }
                            ++n2;
                        }
                    }
                    break;
                }
            }
            if (useLong) {
                return (Long)mCallWindowProc.invoke(null, oldProc, hwnd, (int)msg, wParam, lParam);
            }
            return ((Integer)mCallWindowProc.invoke(null, (int)oldProc, (int)hwnd, (int)msg, (int)wParam, (int)lParam)).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

