/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.webplugin;

import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.config.ConfigParameter;
import com.biglybt.pif.config.ConfigParameterListener;
import com.biglybt.pifimpl.remote.RPRequest;
import com.biglybt.pifimpl.remote.RPRequestAccessController;
import com.biglybt.pifimpl.remote.rpexceptions.RPMethodAccessDeniedException;
import com.biglybt.ui.webplugin.WebPlugin;

public class WebPluginAccessController
implements RPRequestAccessController {
    protected boolean view_mode;

    public WebPluginAccessController(final PluginInterface pi) {
        ConfigParameter mode_parameter = pi.getPluginconfig().getPluginParameter("Mode");
        if (mode_parameter == null) {
            this.view_mode = true;
        } else {
            mode_parameter.addConfigParameterListener(new ConfigParameterListener(){

                @Override
                public void configParameterChanged(ConfigParameter param) {
                    WebPluginAccessController.this.setViewMode(pi);
                }
            });
            this.setViewMode(pi);
        }
    }

    protected void setViewMode(PluginInterface pi) {
        WebPlugin cfr_ignored_0 = (WebPlugin)pi.getPlugin();
        String mode_str = pi.getPluginconfig().getPluginStringParameter("Mode", "full");
        this.view_mode = !mode_str.equalsIgnoreCase("full");
    }

    public void checkUploadAllowed() {
        if (this.view_mode) {
            throw new RPMethodAccessDeniedException();
        }
    }

    @Override
    public void checkAccess(String name, RPRequest request2) {
        String method = request2.getMethod();
        if (this.view_mode) {
            boolean ok = false;
            if (name.equals("PluginInterface")) {
                ok = method.equals("getPluginconfig") || method.equals("getDownloadManager") || method.equals("getIPFilter");
            } else if (name.equals("DownloadManager")) {
                ok = method.equals("getDownloads");
            } else if (name.equals("PluginConfig")) {
                if (method.startsWith("getPlugin") || method.equals("save")) {
                    ok = true;
                } else if (method.equals("setPluginParameter[String,int]")) {
                    String param = (String)request2.getParams()[0];
                    ok = param.equals("MDConfigModel:refresh_period");
                }
            }
            if (!ok) {
                throw new RPMethodAccessDeniedException();
            }
        }
    }
}

