/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class DataSourceUtils {
    public static com.biglybt.core.disk.DiskManagerFileInfo getFileInfo(Object ds) {
        try {
            if (ds instanceof DiskManagerFileInfo) {
                return PluginCoreUtils.unwrap((DiskManagerFileInfo)ds);
            }
            if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
                return (com.biglybt.core.disk.DiskManagerFileInfo)ds;
            }
            if (ds instanceof ISelectedContent && ((ISelectedContent)ds).getFileIndex() >= 0) {
                ISelectedContent sc = (ISelectedContent)ds;
                int idx = sc.getFileIndex();
                DownloadManager dm = sc.getDownloadManager();
                return dm.getDiskManagerFileInfoSet().getFiles()[idx];
            }
            if (ds instanceof TranscodeJob) {
                TranscodeJob tj = (TranscodeJob)ds;
                try {
                    return PluginCoreUtils.unwrap(tj.getFile());
                }
                catch (DownloadException idx) {
                }
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                try {
                    DiskManagerFileInfo file = tf.getSourceFile();
                    return PluginCoreUtils.unwrap(file);
                }
                catch (DownloadException downloadException) {}
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadManager getDM(Object ds) {
        try {
            com.biglybt.core.disk.DiskManagerFileInfo fileInfo2;
            if (ds instanceof DownloadManager) {
                return (DownloadManager)ds;
            }
            if (ds instanceof ActivitiesEntry) {
                String assetHash;
                ActivitiesEntry entry = (ActivitiesEntry)ds;
                DownloadManager dm = entry.getDownloadManger();
                if (dm == null && (assetHash = entry.getAssetHash()) != null && CoreFactory.isCoreRunning()) {
                    GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                    dm = gm.getDownloadManager(new HashWrapper(Base32.decode(assetHash)));
                    entry.setDownloadManager(dm);
                }
                return dm;
            }
            if (ds instanceof TOTorrent && CoreFactory.isCoreRunning()) {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                return gm.getDownloadManager((TOTorrent)ds);
            }
            if (ds instanceof ISelectedContent) {
                return DataSourceUtils.getDM(((ISelectedContent)ds).getDownloadManager());
            }
            if (ds instanceof TranscodeJob) {
                TranscodeJob tj = (TranscodeJob)ds;
                try {
                    Download download;
                    DiskManagerFileInfo file = tj.getFile();
                    if (file != null && (download = tj.getFile().getDownload()) != null) {
                        return PluginCoreUtils.unwrap(download);
                    }
                }
                catch (DownloadException file) {}
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                try {
                    Download download;
                    DiskManagerFileInfo file = tf.getSourceFile();
                    if (file != null && (download = file.getDownload()) != null) {
                        return PluginCoreUtils.unwrap(download);
                    }
                }
                catch (DownloadException file) {}
            } else {
                Object hash;
                if (ds instanceof Download) {
                    return PluginCoreUtils.unwrap((Download)ds);
                }
                if (ds instanceof byte[]) {
                    hash = (byte[])ds;
                    GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                    DownloadManager dm = gm.getDownloadManager(new HashWrapper((byte[])hash));
                    if (dm != null) {
                        return dm;
                    }
                } else {
                    DiskManager diskManager;
                    if (ds instanceof Object[]) {
                        Object[] o = (Object[])ds;
                        return o.length == 0 ? null : DataSourceUtils.getDM(o[0]);
                    }
                    if (ds instanceof String && CoreFactory.isCoreRunning()) {
                        hash = (String)ds;
                        try {
                            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                            DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode((String)hash)));
                            if (dm != null) {
                                return dm;
                            }
                        }
                        catch (Exception gm) {}
                    } else if (ds instanceof PEPiece && (diskManager = ((PEPiece)ds).getDMPiece().getManager()) instanceof DiskManagerImpl) {
                        DiskManagerImpl dmi = (DiskManagerImpl)diskManager;
                        return dmi.getDownloadManager();
                    }
                }
            }
            if ((fileInfo2 = DataSourceUtils.getFileInfo(ds)) != null) {
                return fileInfo2.getDownloadManager();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadManager[] getDMs(Object ds) {
        Object[] objectArray;
        if (ds instanceof List) {
            ds = ((List)ds).toArray(new Object[0]);
        }
        if (ds instanceof Object[]) {
            objectArray = ds;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ds;
        }
        Object[] dsArray = objectArray;
        LinkedHashSet<DownloadManager> managers = new LinkedHashSet<DownloadManager>();
        Object[] objectArray3 = dsArray;
        int n = dsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray3[n2];
            if (o instanceof TagDownload) {
                managers.addAll(((TagDownload)o).getTaggedDownloads());
            } else {
                DownloadManager dm = DataSourceUtils.getDM(o);
                if (dm != null) {
                    managers.add(dm);
                }
            }
            ++n2;
        }
        return managers.toArray(new DownloadManager[0]);
    }

    public static PEPiece[] getPieces(Object ds) {
        Object[] objectArray;
        if (ds instanceof Object[]) {
            objectArray = (Object[])ds;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ds;
        }
        Object[] dsArray = objectArray;
        ArrayList<PEPiece> list = new ArrayList<PEPiece>();
        Object[] objectArray3 = dsArray;
        int n = dsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray3[n2];
            if (o instanceof PEPiece) {
                list.add((PEPiece)o);
            }
            ++n2;
        }
        return list.toArray(new PEPiece[0]);
    }

    public static TOTorrent getTorrent(Object ds) {
        DownloadManager dm;
        Torrent torrent;
        Download download;
        DiskManagerFileInfo file2;
        TOTorrent torrent2;
        if (ds instanceof TOTorrent) {
            return (TOTorrent)ds;
        }
        if (ds instanceof DownloadManager && (torrent2 = ((DownloadManager)ds).getTorrent()) != null) {
            return torrent2;
        }
        if (ds instanceof ActivitiesEntry) {
            DownloadManager dm2;
            torrent2 = ((ActivitiesEntry)ds).getTorrent();
            if (torrent2 == null && (dm2 = DataSourceUtils.getDM(ds)) != null) {
                torrent2 = dm2.getTorrent();
            }
            return torrent2;
        }
        if (ds instanceof TranscodeFile) {
            TranscodeFile tf = (TranscodeFile)ds;
            try {
                file2 = tf.getSourceFile();
                if (file2 != null && (download = file2.getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (Throwable file2) {
                // empty catch block
            }
        }
        if (ds instanceof TranscodeJob) {
            TranscodeJob tj = (TranscodeJob)ds;
            try {
                file2 = tj.getFile();
                if (file2 != null && (download = tj.getFile().getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (DownloadException file3) {
                // empty catch block
            }
        }
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getTorrent();
        }
        if (ds instanceof String) {
            String hash = (String)ds;
            try {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                DownloadManager dm3 = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm3 != null) {
                    return dm3.getTorrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((dm = DataSourceUtils.getDM(ds)) != null) {
            return dm.getTorrent();
        }
        return null;
    }

    public static String getHash(Object ds) {
        try {
            if (ds instanceof ActivitiesEntry) {
                ActivitiesEntry entry = (ActivitiesEntry)ds;
                return entry.getAssetHash();
            }
            if (ds instanceof ISelectedContent) {
                return ((ISelectedContent)ds).getHash();
            }
            if (ds instanceof byte[]) {
                return Base32.encode((byte[])ds);
            }
            if (ds instanceof String) {
                return (String)ds;
            }
            TOTorrent torrent = DataSourceUtils.getTorrent(ds);
            if (torrent != null) {
                return torrent.getHashWrapper().toBase32String();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadUrlInfo getDownloadInfo(Object ds) {
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getDownloadInfo();
        }
        return null;
    }

    public static Tag getTag(Object ds) {
        if (ds instanceof Tag) {
            return (Tag)ds;
        }
        if (ds instanceof Number) {
            long tag_uid = ((Number)ds).longValue();
            return TagManagerFactory.getTagManager().lookupTagByUID(tag_uid);
        }
        if (ds instanceof Object[]) {
            Object[] array;
            Object[] objectArray = array = (Object[])ds;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Tag tag = DataSourceUtils.getTag(o);
                if (tag != null) {
                    return tag;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Tag[] getTags(Object ds) {
        Tag[] tagArray;
        if (ds instanceof Object[]) {
            Object[] dsMulti;
            ArrayList<Tag> list = new ArrayList<Tag>();
            Object[] objectArray = dsMulti = (Object[])ds;
            int n = dsMulti.length;
            int n2 = 0;
            while (n2 < n) {
                Object dsOne = objectArray[n2];
                Tag tag = DataSourceUtils.getTag(dsOne);
                if (tag != null) {
                    list.add(tag);
                }
                ++n2;
            }
            return list.toArray(new Tag[0]);
        }
        Tag tag = DataSourceUtils.getTag(ds);
        if (tag == null) {
            tagArray = new Tag[]{};
        } else {
            Tag[] tagArray2 = new Tag[1];
            tagArray = tagArray2;
            tagArray2[0] = tag;
        }
        return tagArray;
    }

    public static boolean areSame(Object ds0, Object ds1) {
        boolean isArray0 = ds0 instanceof Object[];
        boolean isArray1 = ds1 instanceof Object[];
        if (isArray0 != isArray1) {
            int len1;
            int len0;
            int n = isArray0 ? ((Object[])ds0).length : (len0 = ds0 == null ? 0 : 1);
            int n2 = isArray1 ? ((Object[])ds1).length : (len1 = ds1 == null ? 0 : 1);
            if (len0 == 1 && len1 == 1) {
                Object oneDS1;
                Object oneDS0 = isArray0 ? ((Object[])ds0)[0] : ds0;
                Object object = oneDS1 = isArray1 ? ((Object[])ds1)[0] : ds1;
                return oneDS0 == oneDS1;
            }
            return len0 == 0 && len1 == 0;
        }
        if (isArray0) {
            return Arrays.equals((Object[])ds0, (Object[])ds1);
        }
        return ds0 == ds1;
    }

    public static String toDebugString(Object data) {
        return data instanceof Object[] ? Arrays.toString((Object[])data) : "" + data;
    }

    public static boolean isPluginTypeCompatible(Class pluginDSClass, Class DSClass) {
        if (pluginDSClass.equals(DSClass)) {
            return true;
        }
        return pluginDSClass == Download.class && (DSClass == DownloadTypeComplete.class || DSClass == DownloadTypeIncomplete.class);
    }
}

