/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.core.Core;
import com.biglybt.core.content.PlatformContentDirectory;
import com.biglybt.core.content.RelatedContentManager;
import com.biglybt.core.devices.DeviceManagerFactory;
import com.biglybt.core.download.DownloadManagerEnhancer;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.MetaSearchManagerListener;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadWillBeAddedListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.plugin.net.buddy.BuddyPluginUI;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.ExternalStimulusHandler;
import com.biglybt.util.NavigationHelper;

public class InitialisationFunctions {
    private static boolean earlyInitDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void earlyInitialisation(Core core) {
        Class<InitialisationFunctions> clazz = InitialisationFunctions.class;
        synchronized (InitialisationFunctions.class) {
            if (earlyInitDone) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            earlyInitDone = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            DownloadManagerEnhancer.initialise(core);
            InitialisationFunctions.hookDownloadAddition();
            PlatformContentDirectory.register();
            MetaSearchManagerFactory.preInitialise();
            SubscriptionManagerFactory.preInitialise();
            DeviceManagerFactory.preInitialise();
            NavigationHelper.initialise();
            RelatedContentManager.preInitialise(core);
            InitialisationFunctions.earlySWTInitialise();
            return;
        }
    }

    private static void earlySWTInitialise() {
        UIFunctionsManager.execWithUIFunctions(new UIFunctionsManager.UIFCallback(){

            @Override
            public void run(UIFunctions uif) {
                if (uif.getUIType().equals("swt")) {
                    BuddyPluginUI.preInitialize();
                }
            }
        });
    }

    public static void lateInitialisation(Core core) {
        ExternalStimulusHandler.initialise(core);
        PluginInitializer.getDefaultInterface().getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
                try {
                    RelatedContentManager.getSingleton();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                try {
                    MetaSearchManagerFactory.getSingleton().addListener(new MetaSearchManagerListener(){

                        @Override
                        public void searchRequest(String term) {
                            UIFunctionsManager.getUIFunctions().doSearch(term);
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }).queue();
    }

    protected static void hookDownloadAddition() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        dm.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            @Override
            public void initialised(Download download) {
                com.biglybt.core.download.DownloadManager dm = PluginCoreUtils.unwrap(download);
                if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                    PlatformTorrentUtils.setHasBeenOpened(dm, false);
                }
            }
        });
    }
}

