/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class LocalResourceHTTPServer
implements TrackerWebPageGenerator {
    private static final String my_ip = "127.0.0.1";
    private int my_port;
    private LoggerChannel logger;
    private int resource_id_next;
    private Map published_resources = new HashMap();

    public LocalResourceHTTPServer(PluginInterface _plugin_interface, LoggerChannel _logger) throws Exception {
        this.logger = _logger;
        this.resource_id_next = new Random().nextInt(0x3FFFFFFF);
        InetAddress bind_address = InetAddress.getByName(my_ip);
        TrackerWebContext context2 = _plugin_interface.getTracker().createWebContext("Director:localResource", 0, 1, bind_address);
        this.my_port = context2.getURLs()[0].getPort();
        if (this.logger != null) {
            this.logger.log("Local resource publisher running on 127.0.0.1:" + this.my_port);
        }
        context2.addPageGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        File resource;
        String path = request2.getURL();
        LocalResourceHTTPServer localResourceHTTPServer = this;
        synchronized (localResourceHTTPServer) {
            resource = (File)this.published_resources.get(path);
        }
        if (resource == null) {
            return false;
        }
        return response.useFile(resource.getParent(), "/" + resource.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL publishResource(File resource) throws Exception {
        LocalResourceHTTPServer localResourceHTTPServer = this;
        synchronized (localResourceHTTPServer) {
            resource = resource.getCanonicalFile();
            URL result = new URL("http://127.0.0.1:" + this.my_port + "/" + this.resource_id_next++ + "/" + resource.getName());
            this.published_resources.put(result.getPath(), resource);
            if (this.logger != null) {
                this.logger.log("Local resource added: " + resource + " -> " + result);
            }
            return result;
        }
    }
}

