/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.util;

import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gudy.bouncycastle.util.encoders.Base64;
import org.json.simple.JSONArray;

public class MapUtils {
    public static void setMapInt(Map map, String key, int val) {
        map.put(key, new Long(val));
    }

    public static int getMapInt(Map map, String key, int def) {
        if (map == null) {
            return def;
        }
        try {
            Number n = (Number)map.get(key);
            if (n == null) {
                return def;
            }
            return n.intValue();
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static long getMapLong(Map map, String key, long def) {
        if (map == null) {
            return def;
        }
        try {
            Number n = (Number)map.get(key);
            if (n == null) {
                return def;
            }
            return n.longValue();
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static String getMapString(Map map, String key, String def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o == null && !map.containsKey(key)) {
                return def;
            }
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof byte[]) {
                return new String((byte[])o, Constants.UTF_8);
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static String[] getMapStringArray(Map map, String key, String[] def) {
        Object o = map.get(key);
        if (!(o instanceof List)) {
            return def;
        }
        List list = (List)o;
        String[] result = new String[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = MapUtils.getString(list.get(i));
            ++i;
        }
        return result;
    }

    public static String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, Constants.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setMapString(Map map, String key, String val) {
        if (map == null) {
            Debug.out("Map is null!");
            return;
        }
        try {
            if (val == null) {
                map.remove(key);
            } else {
                map.put(key, val.getBytes(Constants.UTF_8));
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public static byte[] getMapByteArray(Map map, String key, byte[] def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            String b64Key = String.valueOf(key) + ".B64";
            if (map.containsKey(b64Key) && (o = map.get(b64Key)) instanceof String) {
                return Base64.decode((String)o);
            }
            String b32Key = String.valueOf(key) + ".B32";
            if (map.containsKey(b32Key) && (o = map.get(b32Key)) instanceof String) {
                return Base32.decode((String)o);
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static Object getMapObject(Map map, String key, Object def, Class cla) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (cla.isInstance(o)) {
                return o;
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static void setMapBoolean(Map map, String key, boolean val) {
        map.put(key, new Long(val ? 1 : 0));
    }

    public static boolean getMapBoolean(Map map, String key, boolean def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue() == 1L;
            }
            return def;
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static List getMapList(Map map, String key, List def) {
        if (map == null) {
            return def;
        }
        try {
            List list = (List)map.get(key);
            if (list == null && !map.containsKey(key)) {
                return def;
            }
            return list;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static Map getMapMap(Map map, String key, Map def) {
        if (map == null) {
            return def;
        }
        try {
            Map valMap = (Map)map.get(key);
            if (valMap == null && !map.containsKey(key)) {
                return def;
            }
            return valMap;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static long importLong(Map map, String key, long def) {
        if (map == null) {
            return def;
        }
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        return def;
    }

    public static void exportLong(Map map, String key, long value) {
        map.put(key, value);
    }

    public static void exportInt(Map map, String key, int value) {
        map.put(key, new Long(value));
    }

    public static int importInt(Map map, String key, int def) {
        return (int)MapUtils.importLong(map, key, def);
    }

    public static void exportFloatAsString(Map map, String key, float value) {
        MapUtils.setMapString(map, key, String.valueOf(value));
    }

    public static float importFloatFromString(Map map, String key, float def) {
        String str = MapUtils.getMapString(map, key, null);
        if (str == null) {
            return def;
        }
        return Float.parseFloat(str);
    }

    public static void exportBooleanAsLong(Map map, String key, boolean value) {
        map.put(key, new Long(value ? 1 : 0));
    }

    public static String importURL(Map map, String key) {
        String url = MapUtils.getMapString(map, key, null);
        if (url != null) {
            if ((url = url.trim()).length() == 0) {
                url = null;
            } else {
                try {
                    url = URLDecoder.decode(url, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return url;
    }

    public static void exportJSONURL(Map map, String key, String value) {
        map.put(key, UrlUtils.encode(value));
    }

    public static String[] importStringArray(Map map, String key) {
        List list = (List)map.get(key);
        if (list == null) {
            return new String[0];
        }
        String[] res = new String[list.size()];
        int i = 0;
        while (i < res.length) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                res[i] = (String)obj;
            } else if (obj instanceof byte[]) {
                res[i] = new String((byte[])obj, Constants.UTF_8);
            }
            ++i;
        }
        return res;
    }

    public static void exportStringArray(Map map, String key, String[] data) {
        ArrayList<byte[]> l = new ArrayList<byte[]>(data.length);
        map.put(key, l);
        int i = 0;
        while (i < data.length) {
            l.add(data[i].getBytes(Constants.UTF_8));
            ++i;
        }
    }

    public static void exportJSONStringArray(Map map, String key, String[] data) {
        JSONArray l = new JSONArray(data.length);
        map.put(key, l);
        Collections.addAll(l, data);
    }

    public static void exportIntArrayAsByteArray(Map map, String key, int[] values) {
        if (values == null) {
            return;
        }
        int num = values.length;
        byte[] bytes = new byte[num * 4];
        int pos = 0;
        int i = 0;
        while (i < num) {
            int v = values[i];
            bytes[pos++] = (byte)(v >>> 24);
            bytes[pos++] = (byte)(v >>> 16);
            bytes[pos++] = (byte)(v >>> 8);
            bytes[pos++] = (byte)v;
            ++i;
        }
        map.put(key, bytes);
    }

    public static int[] importIntArray(Map map, String key) {
        byte[] bytes = (byte[])map.get(key);
        if (bytes == null) {
            return null;
        }
        int[] values = new int[bytes.length / 4];
        int pos = 0;
        int i = 0;
        while (i < values.length) {
            values[i] = ((bytes[pos++] & 0xFF) << 24) + ((bytes[pos++] & 0xFF) << 16) + ((bytes[pos++] & 0xFF) << 8) + (bytes[pos++] & 0xFF);
            ++i;
        }
        return values;
    }

    public static String importString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            return new String((byte[])o, Constants.UTF_8);
        }
        Debug.out("unsupported: " + o);
        return null;
    }

    public static <K> K[] sortCount(Map<K, Integer> map, int limit) {
        if (map.isEmpty()) {
            return null;
        }
        ArrayList<K> names = new ArrayList<K>(map.keySet());
        names.sort(Comparator.comparing(map::get, Comparator.reverseOrder()));
        Object[] o = (Object[])Array.newInstance(names.get(0).getClass(), Math.min(limit, names.size()));
        return names.toArray(o);
    }
}

