/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1;

import java.io.IOException;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROutputStream;

public class DERUnknownTag
extends DERObject {
    int tag;
    byte[] data;

    public DERUnknownTag(int tag, byte[] data) {
        this.tag = tag;
        this.data = data;
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(this.tag, this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DERUnknownTag)) {
            return false;
        }
        DERUnknownTag other = (DERUnknownTag)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.data.length != other.data.length) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != other.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] b = this.getData();
        int value = 0;
        int i = 0;
        while (i != b.length) {
            value ^= (b[i] & 0xFF) << i % 4;
            ++i;
        }
        return value ^ this.getTag();
    }
}

