/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.gudy.bouncycastle.crypto.KeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int qLength = this.param.getStrength() - 1;
        ElGamalParameters elParams = this.param.getParameters();
        BigInteger p = elParams.getP();
        BigInteger g = elParams.getG();
        BigInteger x = new BigInteger(qLength, this.param.getRandom());
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, elParams), new ElGamalPrivateKeyParameters(x, elParams));
    }
}

